/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.calculators;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import technology.rocketjump.undermount.mapgen.model.TileType;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.MapRegion;
import technology.rocketjump.undermount.mapgen.model.output.MapSubRegion;
import technology.rocketjump.undermount.mapgen.model.output.TileSubType;

public class RegionCalculator {
    public void assignRegions(GameMap map) {
        HashSet<GameMapTile> assigned = new HashSet<GameMapTile>();
        for (int x = 0; x < map.getWidth(); ++x) {
            for (int y = 0; y < map.getHeight(); ++y) {
                GameMapTile currentTile = map.get(x, y);
                if (assigned.contains(currentTile)) continue;
                this.floodFillRegion(currentTile, map, assigned);
            }
        }
    }

    public void assignSubRegions(GameMap map) {
        HashSet<GameMapTile> assigned = new HashSet<GameMapTile>();
        for (int x = 0; x < map.getWidth(); ++x) {
            for (int y = 0; y < map.getHeight(); ++y) {
                GameMapTile currentTile = map.get(x, y);
                if (assigned.contains(currentTile)) continue;
                this.floodFillSubRegion(currentTile, map, assigned);
            }
        }
    }

    private void floodFillRegion(GameMapTile initialTile, GameMap map, Set<GameMapTile> assigned) {
        TileType regionTileType = initialTile.getTileType();
        MapRegion region = new MapRegion(regionTileType);
        HashSet<GameMapTile> ignored = new HashSet<GameMapTile>();
        LinkedList<GameMapTile> frontier = new LinkedList<GameMapTile>();
        frontier.add(initialTile);
        while (!frontier.isEmpty()) {
            GameMapTile currentTile = (GameMapTile)frontier.removeFirst();
            if (currentTile.getTileType().equals((Object)regionTileType)) {
                region.add(currentTile, map);
                assigned.add(currentTile);
                for (GameMapTile neighbour : map.getOrthogonalNeighbours(currentTile.getPosition())) {
                    if (frontier.contains(neighbour) || ignored.contains(neighbour) || assigned.contains(neighbour)) continue;
                    frontier.add(neighbour);
                }
                continue;
            }
            ignored.add(currentTile);
        }
        map.addRegion(region);
    }

    private void floodFillSubRegion(GameMapTile initialTile, GameMap map, Set<GameMapTile> assigned) {
        TileSubType subRegionType = initialTile.getTileSubType();
        MapSubRegion subRegion = new MapSubRegion(subRegionType);
        HashSet<GameMapTile> ignored = new HashSet<GameMapTile>();
        LinkedList<GameMapTile> frontier = new LinkedList<GameMapTile>();
        frontier.add(initialTile);
        while (!frontier.isEmpty()) {
            GameMapTile currentTile = (GameMapTile)frontier.removeFirst();
            if (currentTile.getTileSubType().equals((Object)subRegionType)) {
                subRegion.add(currentTile);
                assigned.add(currentTile);
                for (GameMapTile neighbour : map.getOrthogonalNeighbours(currentTile.getPosition())) {
                    if (frontier.contains(neighbour) || ignored.contains(neighbour) || assigned.contains(neighbour)) continue;
                    frontier.add(neighbour);
                }
                continue;
            }
            ignored.add(currentTile);
        }
        map.addSubRegion(subRegion);
    }
}

